/**
 * Generated Pins header File
 * 
 * @file pins.h
 * 
 * @defgroup  pinsdriver Pins Driver
 * 
 * @brief This is generated driver header for pins. 
 *        This header file provides APIs for all pins selected in the GUI.
 *
 * @version Driver Version  3.0.0
*/

/*
 [2024] Microchip Technology Inc. and its subsidiaries.

    Subject to your compliance with these terms, you may use Microchip 
    software and any derivatives exclusively with Microchip products. 
    You are responsible for complying with 3rd party license terms  
    applicable to your use of 3rd party software (including open source  
    software) that may accompany Microchip software. SOFTWARE IS ?AS IS.? 
    NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS 
    SOFTWARE, INCLUDING ANY IMPLIED WARRANTIES OF NON-INFRINGEMENT,  
    MERCHANTABILITY, OR FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT 
    WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE, 
    INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY 
    KIND WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF 
    MICROCHIP HAS BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE 
    FORESEEABLE. TO THE FULLEST EXTENT ALLOWED BY LAW, MICROCHIP?S 
    TOTAL LIABILITY ON ALL CLAIMS RELATED TO THE SOFTWARE WILL NOT 
    EXCEED AMOUNT OF FEES, IF ANY, YOU PAID DIRECTLY TO MICROCHIP FOR 
    THIS SOFTWARE.
*/

#ifndef PINS_H
#define PINS_H

#include <xc.h>

#define INPUT   1
#define OUTPUT  0

#define HIGH    1
#define LOW     0

#define ANALOG      1
#define DIGITAL     0

#define PULL_UP_ENABLED      1
#define PULL_UP_DISABLED     0

// get/set IO_RA0 aliases
#define Run_Button_TRIS                 TRISAbits.TRISA0
#define Run_Button_LAT                  LATAbits.LATA0
#define Run_Button_PORT                 PORTAbits.RA0
#define Run_Button_WPU                  WPUAbits.WPUA0
#define Run_Button_OD                   ODCONAbits.ODCA0
#define Run_Button_ANS                  ANSELAbits.ANSA0
#define Run_Button_SetHigh()            do { LATAbits.LATA0 = 1; } while(0)
#define Run_Button_SetLow()             do { LATAbits.LATA0 = 0; } while(0)
#define Run_Button_Toggle()             do { LATAbits.LATA0 = ~LATAbits.LATA0; } while(0)
#define Run_Button_GetValue()           PORTAbits.RA0
#define Run_Button_SetDigitalInput()    do { TRISAbits.TRISA0 = 1; } while(0)
#define Run_Button_SetDigitalOutput()   do { TRISAbits.TRISA0 = 0; } while(0)
#define Run_Button_SetPullup()          do { WPUAbits.WPUA0 = 1; } while(0)
#define Run_Button_ResetPullup()        do { WPUAbits.WPUA0 = 0; } while(0)
#define Run_Button_SetPushPull()        do { ODCONAbits.ODCA0 = 0; } while(0)
#define Run_Button_SetOpenDrain()       do { ODCONAbits.ODCA0 = 1; } while(0)
#define Run_Button_SetAnalogMode()      do { ANSELAbits.ANSA0 = 1; } while(0)
#define Run_Button_SetDigitalMode()     do { ANSELAbits.ANSA0 = 0; } while(0)
// get/set IO_RA1 aliases
#define Vent_Fan_TRIS                 TRISAbits.TRISA1
#define Vent_Fan_LAT                  LATAbits.LATA1
#define Vent_Fan_PORT                 PORTAbits.RA1
#define Vent_Fan_WPU                  WPUAbits.WPUA1
#define Vent_Fan_OD                   ODCONAbits.ODCA1
#define Vent_Fan_ANS                  ANSELAbits.ANSA1
#define Vent_Fan_SetHigh()            do { LATAbits.LATA1 = 1; } while(0)
#define Vent_Fan_SetLow()             do { LATAbits.LATA1 = 0; } while(0)
#define Vent_Fan_Toggle()             do { LATAbits.LATA1 = ~LATAbits.LATA1; } while(0)
#define Vent_Fan_GetValue()           PORTAbits.RA1
#define Vent_Fan_SetDigitalInput()    do { TRISAbits.TRISA1 = 1; } while(0)
#define Vent_Fan_SetDigitalOutput()   do { TRISAbits.TRISA1 = 0; } while(0)
#define Vent_Fan_SetPullup()          do { WPUAbits.WPUA1 = 1; } while(0)
#define Vent_Fan_ResetPullup()        do { WPUAbits.WPUA1 = 0; } while(0)
#define Vent_Fan_SetPushPull()        do { ODCONAbits.ODCA1 = 0; } while(0)
#define Vent_Fan_SetOpenDrain()       do { ODCONAbits.ODCA1 = 1; } while(0)
#define Vent_Fan_SetAnalogMode()      do { ANSELAbits.ANSA1 = 1; } while(0)
#define Vent_Fan_SetDigitalMode()     do { ANSELAbits.ANSA1 = 0; } while(0)
// get/set IO_RA2 aliases
#define Heater_Enable_TRIS                 TRISAbits.TRISA2
#define Heater_Enable_LAT                  LATAbits.LATA2
#define Heater_Enable_PORT                 PORTAbits.RA2
#define Heater_Enable_WPU                  WPUAbits.WPUA2
#define Heater_Enable_OD                   ODCONAbits.ODCA2
#define Heater_Enable_ANS                  ANSELAbits.ANSA2
#define Heater_Enable_SetHigh()            do { LATAbits.LATA2 = 1; } while(0)
#define Heater_Enable_SetLow()             do { LATAbits.LATA2 = 0; } while(0)
#define Heater_Enable_Toggle()             do { LATAbits.LATA2 = ~LATAbits.LATA2; } while(0)
#define Heater_Enable_GetValue()           PORTAbits.RA2
#define Heater_Enable_SetDigitalInput()    do { TRISAbits.TRISA2 = 1; } while(0)
#define Heater_Enable_SetDigitalOutput()   do { TRISAbits.TRISA2 = 0; } while(0)
#define Heater_Enable_SetPullup()          do { WPUAbits.WPUA2 = 1; } while(0)
#define Heater_Enable_ResetPullup()        do { WPUAbits.WPUA2 = 0; } while(0)
#define Heater_Enable_SetPushPull()        do { ODCONAbits.ODCA2 = 0; } while(0)
#define Heater_Enable_SetOpenDrain()       do { ODCONAbits.ODCA2 = 1; } while(0)
#define Heater_Enable_SetAnalogMode()      do { ANSELAbits.ANSA2 = 1; } while(0)
#define Heater_Enable_SetDigitalMode()     do { ANSELAbits.ANSA2 = 0; } while(0)
// get/set IO_RA4 aliases
#define Time_6h_TRIS                 TRISAbits.TRISA4
#define Time_6h_LAT                  LATAbits.LATA4
#define Time_6h_PORT                 PORTAbits.RA4
#define Time_6h_WPU                  WPUAbits.WPUA4
#define Time_6h_OD                   ODCONAbits.ODCA4
#define Time_6h_ANS                  ANSELAbits.ANSA4
#define Time_6h_SetHigh()            do { LATAbits.LATA4 = 1; } while(0)
#define Time_6h_SetLow()             do { LATAbits.LATA4 = 0; } while(0)
#define Time_6h_Toggle()             do { LATAbits.LATA4 = ~LATAbits.LATA4; } while(0)
#define Time_6h_GetValue()           PORTAbits.RA4
#define Time_6h_SetDigitalInput()    do { TRISAbits.TRISA4 = 1; } while(0)
#define Time_6h_SetDigitalOutput()   do { TRISAbits.TRISA4 = 0; } while(0)
#define Time_6h_SetPullup()          do { WPUAbits.WPUA4 = 1; } while(0)
#define Time_6h_ResetPullup()        do { WPUAbits.WPUA4 = 0; } while(0)
#define Time_6h_SetPushPull()        do { ODCONAbits.ODCA4 = 0; } while(0)
#define Time_6h_SetOpenDrain()       do { ODCONAbits.ODCA4 = 1; } while(0)
#define Time_6h_SetAnalogMode()      do { ANSELAbits.ANSA4 = 1; } while(0)
#define Time_6h_SetDigitalMode()     do { ANSELAbits.ANSA4 = 0; } while(0)
// get/set IO_RA5 aliases
#define Time_12h_TRIS                 TRISAbits.TRISA5
#define Time_12h_LAT                  LATAbits.LATA5
#define Time_12h_PORT                 PORTAbits.RA5
#define Time_12h_WPU                  WPUAbits.WPUA5
#define Time_12h_OD                   ODCONAbits.ODCA5
#define Time_12h_ANS                  ANSELAbits.ANSA5
#define Time_12h_SetHigh()            do { LATAbits.LATA5 = 1; } while(0)
#define Time_12h_SetLow()             do { LATAbits.LATA5 = 0; } while(0)
#define Time_12h_Toggle()             do { LATAbits.LATA5 = ~LATAbits.LATA5; } while(0)
#define Time_12h_GetValue()           PORTAbits.RA5
#define Time_12h_SetDigitalInput()    do { TRISAbits.TRISA5 = 1; } while(0)
#define Time_12h_SetDigitalOutput()   do { TRISAbits.TRISA5 = 0; } while(0)
#define Time_12h_SetPullup()          do { WPUAbits.WPUA5 = 1; } while(0)
#define Time_12h_ResetPullup()        do { WPUAbits.WPUA5 = 0; } while(0)
#define Time_12h_SetPushPull()        do { ODCONAbits.ODCA5 = 0; } while(0)
#define Time_12h_SetOpenDrain()       do { ODCONAbits.ODCA5 = 1; } while(0)
#define Time_12h_SetAnalogMode()      do { ANSELAbits.ANSA5 = 1; } while(0)
#define Time_12h_SetDigitalMode()     do { ANSELAbits.ANSA5 = 0; } while(0)
/**
 * @ingroup  pinsdriver
 * @brief GPIO and peripheral I/O initialization
 * @param none
 * @return none
 */
void PIN_MANAGER_Initialize (void);

/**
 * @ingroup  pinsdriver
 * @brief Interrupt on Change Handling routine
 * @param none
 * @return none
 */
void PIN_MANAGER_IOC(void);


#endif // PINS_H
/**
 End of File
*/